<h3 class="title mb-4"><?php echo e(__('Edit Staff')); ?></h3>
<form action="<?php echo e(route('admin.staff.update',$staff->id)); ?>" method="post">
    <?php echo csrf_field(); ?>
    <?php echo method_field('PUT'); ?>

    <div class="site-input-groups">
        <label for="" class="box-input-label"><?php echo e(__('Name:')); ?></label>
        <input
            type="text"
            name="name"
            class="box-input mb-0"
            value="<?php echo e($staff->name); ?>"
            required=""
            id="name"
        />
    </div>
    <div class="site-input-groups">
        <label for="" class="box-input-label"><?php echo e(__('Email:')); ?></label>
        <input
            type="email"
            name="email"
            class="box-input mb-0"
            value="<?php echo e($staff->email); ?>"
            required=""
            id="email"
        />
    </div>
    <div class="site-input-groups">
        <label for="" class="box-input-label"><?php echo e(__('Password:')); ?></label>
        <input
            type="password"
            name="password"
            class="box-input mb-0"
        />
    </div>
    <div class="site-input-groups">
        <label for="" class="box-input-label"><?php echo e(__('Confirm Password:')); ?></label>
        <input
            type="password"
            name="confirm-password"
            class="box-input mb-0"
        />
    </div>

    <div class="site-input-groups">
        <label class="box-input-label" for=""><?php echo e(__('Status:')); ?></label>
        <div class="switch-field">
            <input type="radio" id="radio-seven" name="status" value="1" <?php if($staff->status): echo 'checked'; endif; ?>>
            <label for="radio-seven"><?php echo e(__('Active')); ?></label>
            <input type="radio" id="radio-eight" name="status" value="0" <?php if(!$staff->status): echo 'checked'; endif; ?>>
            <label for="radio-eight"><?php echo e(__('Disabled')); ?></label>
        </div>
    </div>


    <div class="site-input-groups">
        <label class="box-input-label" for=""><?php echo e(__('Select Role:')); ?></label>
        <select name="role" class="form-select" id="role">
            <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option
                    <?php if($role->name == $staff->roles[0]['name']): echo 'selected'; endif; ?> value="<?php echo e($role->name); ?>"><?php echo e(str_replace('-', ' ', $role->name)); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </select>
    </div>

    <div class="action-btns">
        <button type="submit" href="" class="site-btn-sm primary-btn me-2">
            <i icon-name="check"></i>
            <?php echo e(__('Save Changes')); ?>

        </button>
        <a
            href="#"
            class="site-btn-sm red-btn"
            data-bs-dismiss="modal"
            aria-label="Close"
        >
            <i icon-name="x"></i>
            Close
        </a>
    </div>
</form>
<?php /**PATH /home/notionin/public_html/digitalgrosshub.com/resources/views/backend/staff/include/__edit_form.blade.php ENDPATH**/ ?>