<?php $__env->startSection('title'); ?>
    <?php echo e(__('Withdraw Account Edit')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-xl-12">
            <div class="site-card">
                <div class="site-card-header">
                    <h3 class="title"><?php echo e(__('Edit Withdraw Account')); ?></h3>
                    <div class="card-header-links">
                        <a href="<?php echo e(route('user.withdraw.account.index')); ?>"
                           class="card-header-link"><?php echo e(__('Withdraw Account')); ?></a>
                    </div>
                </div>
                <div class="site-card-body">
                    <div class="progress-steps-form">
                        <form action="<?php echo e(route('user.withdraw.account.update',$withdrawAccount->id)); ?>" method="post"
                              enctype="multipart/form-data">
                            <?php echo method_field('PUT'); ?>
                            <?php echo csrf_field(); ?>

                            <input type="hidden" name="withdraw_method_id"
                                   value="<?php echo e($withdrawAccount->withdraw_method_id); ?>">
                            <div class="row selectMethodRow">
                                <div class="col-xl-6 col-md-12">
                                    <label for="exampleFormControlInput1"
                                           class="form-label"><?php echo e(__('Method Name:')); ?></label>
                                    <div class="input-group">
                                        <input type="text" name="method_name" class="form-control"
                                               placeholder="eg. Withdraw Method - USD"
                                               value="<?php echo e($withdrawAccount->method_name); ?>">
                                    </div>
                                </div>


                                <?php $__currentLoopData = json_decode($withdrawAccount->credentials, true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $field): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                    <?php if($field['type'] == 'file'): ?>

                                        <input type="hidden" name="credentials[<?php echo e($key); ?>][type]"
                                               value="<?php echo e($field['type']); ?>">
                                        <input type="hidden" name="credentials[<?php echo e($key); ?>][validation]"
                                               value="<?php echo e($field['validation']); ?>">

                                        <div class="col-xl-6 col-md-12">
                                            <div class="body-title"><?php echo e($key); ?></div>
                                            <div class="wrap-custom-file">
                                                <input
                                                    type="file"
                                                    name="credentials[<?php echo e($key); ?>][value]"
                                                    id="<?php echo e($key); ?>"
                                                    accept=".gif, .jpg, .png"
                                                    <?php if(data_get($field,'value') == "" && $field['validation'] == 'required'): ?> required <?php endif; ?>
                                                />
                                                <label for="<?php echo e($key); ?>" class="file-ok"
                                                       style="background-image: url(<?php echo e(asset( data_get($field,'value') )); ?>)">
                                                    <img
                                                        class="upload-icon"
                                                        src="<?php echo e(asset('global/materials/upload.svg')); ?>"
                                                        alt=""
                                                    />
                                                    <span><?php echo e(__('Update Icon')); ?></span>
                                                </label>
                                            </div>
                                        </div>
                                    <?php elseif($field['type'] == 'textarea'): ?>
                                        <input type="hidden" name="credentials[<?php echo e($key); ?>][type]"
                                               value="<?php echo e($field['type']); ?>">
                                        <input type="hidden" name="credentials[<?php echo e($key); ?>][validation]"
                                               value="<?php echo e($field['validation']); ?>">

                                        <div class="col-xl-6 col-md-12">
                                            <label for="exampleFormControlInput1" class="form-label"><?php echo e($key); ?></label>
                                            <div class="input-group">
                                                <textarea class="form-control-textarea"
                                                          <?php if($field['validation'] == 'required'): ?> required
                                                          <?php endif; ?> placeholder="Send Money Note"
                                                          name="credentials[<?php echo e($key); ?>][value]"><?php echo e($field['value']); ?></textarea>
                                            </div>
                                        </div>

                                    <?php else: ?>
                                        <input type="hidden" name="credentials[<?php echo e($key); ?>][type]"
                                               value="<?php echo e($field['type']); ?>">
                                        <input type="hidden" name="credentials[<?php echo e($key); ?>][validation]"
                                               value="<?php echo e($field['validation']); ?>">

                                        <div class="col-xl-6 col-md-12">
                                            <label for="exampleFormControlInput1" class="form-label"><?php echo e($key); ?></label>
                                            <div class="input-group">
                                                <input type="text" name="credentials[<?php echo e($key); ?>][value]"
                                                       value="<?php echo e(data_get($field,'value')); ?>"
                                                       <?php if($field['validation'] == 'required'): ?> required
                                                       <?php endif; ?> class="form-control" aria-label="Amount" id="amount"
                                                       aria-describedby="basic-addon1">
                                            </div>
                                        </div>
                                    <?php endif; ?>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                            </div>
                            <div class="buttons">
                                <button type="submit" class="site-btn blue-btn">
                                    <?php echo e(__('Update Withdraw Account')); ?><i class="anticon anticon-double-right"></i>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        $("#selectMethod").on('change', function (e) {
            "use strict"
            e.preventDefault();

            //$('.manual-row').empty();
            $('.selectMethodRow').children().not(':first').remove();

            var id = $(this).val()

            var url = '<?php echo e(route("user.withdraw.method",":id")); ?>';
            url = url.replace(':id', id);
            $.get(url, function (data) {
                $(data).insertAfter(".selectMethodCol");
                imagePreview()
            })
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend::layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/notionin/public_html/digitalgrosshub.com/app/Providers/../../resources/views/frontend/default/withdraw/account/edit.blade.php ENDPATH**/ ?>