<?php
    $schemas = \App\Models\Schema::where('status',true)->with('schedule')->get();
?>
<section class="white-bg section-style-2">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-10 col-lg-12">
                <div class="section-title text-center">
                    <h4 data-aos="fade-down" data-aos-duration="2000"><?php echo e($data['title_small']); ?></h4>
                    <h2 data-aos="fade-down" data-aos-duration="1500"><?php echo e($data['title_big']); ?></h2>
                </div>
            </div>
        </div>
        <div class="row justify-content-center">
            <?php $__currentLoopData = $schemas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $schema): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                <div class="col-xl-4 col-lg-4 col-md-6 col-sm-12 col-12">
                    <div class="single-investment-plan" data-aos="fade-up" data-aos-duration="1500">
                        <div class="investment-plan-icon">
                            <img src="<?php echo e(asset($schema->icon)); ?>" alt=""/>
                            <?php if($schema->badge): ?>
                                <div class="feature-plan"><?php echo e($schema->badge); ?></div>
                            <?php endif; ?>

                            <div class="tranding-icon">
                                <?php if($schema->is_trending): ?>
                                    <i icon-name="zap "></i>
                                <?php else: ?>
                                    <i icon-name="zap-off"></i>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="content">
                            <h3><?php echo e($schema->name); ?></h3>
                            <h4><?php echo e($schema->type == 'range' ? $currencySymbol . $schema->min_amount . ' - ' . $currencySymbol . $schema->max_amount : $currencySymbol . $schema->fixed_amount); ?></h4>
                            <ul>
                                <li><i icon-name="check-check"></i><?php echo e($schema->schedule->name.' '. __('Returns')); ?>

                                    <span><?php echo e($schema->interest_type == 'percentage' ? $schema->return_interest.'%' : $currencySymbol.$schema->return_interest); ?></span>
                                </li>
                                <li><i icon-name="check-check"></i><?php echo e(__('Capital Return')); ?>

                                    <span><?php echo e($schema->capital_back ? __('Yes') : __('No')); ?></span></li>
                                <li><i icon-name="check-check"></i><?php echo e(__('Return Type')); ?>

                                    <span><?php echo e(__(ucwords($schema->return_type))); ?></span></li>
                                <li><i icon-name="check-check"></i><?php echo e(__('Total Periods')); ?>

                                    <span><?php echo e(($schema->return_type == 'period' ? $schema->number_of_period.' ' : __('Unlimited').' ' ).($schema->number_of_period == 1 ? __('Time') : __('Times') )); ?></span>
                                </li>
                                <li><i icon-name="check-check"></i><?php echo e(__('Cancellation')); ?><span><?php if($schema->schema_cancel): ?>
                                            <?php echo e(__('In').' '. $schema->expiry_minute .' '. 'Minute'); ?>

                                        <?php else: ?>
                                            <?php echo e(__('No')); ?>

                                        <?php endif; ?></span></li>
                                <li><i icon-name="check-check"></i><?php echo e(__('Total Revenue')); ?>

                                    <span> <?php echo e($schema->total_revenue); ?></span></li>
                            </ul>

                            <div class="holidays"><span>*</span><?php if( null != $schema->off_days): ?>
                                    <?php echo e(implode(', ', json_decode($schema->off_days,true))  .' '.__('are')); ?>

                                <?php else: ?>
                                    <?php echo e(__('No Profit')); ?>

                                <?php endif; ?> <?php echo e(__('Holidays')); ?></div>

                        </div>
                        <a href="<?php echo e(route('user.schema.preview',$schema->id)); ?>"
                           class="investment-btn w-100 centered"><?php echo e(__('Invest Now')); ?><i
                                icon-name="move-right"></i></a>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<?php /**PATH /home/notionin/public_html/digitalgrosshub.com/app/Providers/../../resources/views/frontend/money_invest/home/include/__schema.blade.php ENDPATH**/ ?>